﻿Shader "Hidden/TriLib/InvertChannelData"
{
	SubShader
	{
		// No culling or depth
		Cull Off ZWrite Off ZTest Always

		Pass
		{
			CGPROGRAM
			#pragma vertex vert
			#pragma fragment frag

			#include "UnityCG.cginc"

			struct appdata
			{
				float4 vertex : POSITION;
				float2 uv : TEXCOORD0;
			};

			struct v2f
			{
				float2 uv : TEXCOORD0;
				float4 vertex : SV_POSITION;
			};

			v2f vert(appdata v)
			{
				v2f o;
				o.vertex = UnityObjectToClipPos(v.vertex);
				o.uv = v.uv;
				return o;
			}

			sampler2D _MainTex;
			int _ChannelIndex;

			float4 frag(v2f i) : SV_Target
			{
				float4 col = tex2D(_MainTex, i.uv);
				switch (_ChannelIndex) {
					case 0:
						return 1.0-col.x;
						break;
					case 1:
						return 1.0 - col.y;
						break;
					case 2:
						return 1.0 - col.z;
						break;
				}
				return 1.0 - col.w;
			}
			ENDCG
		}
	}
}
